<?php

require __DIR__.'/vendor/autoload.php';
$api = new Binance\API($apiKey,$apiSecret);

//////////////////////FUNCIONES//////////////////////
//Tipos de cambio sin involucrar binance
function currencyConvert($de,$hacia){//MXN, EUR o crypto como DOGE, BTC, ETH, USDT-que no viene, si te marca inf es que no encontro esa
    $url='https://bitpay.com/api/rates'; 
    $json=json_decode( file_get_contents( $url ) );
    //todas las monedas vs el btc
    foreach( $json as $obj ){ 
        if( $obj->code==$hacia ){$out=$obj->rate;} //vs el USD que es la que quieres
        if( $obj->code==$de ){$in=$obj->rate;} 
    } 
    if($de == 'USDT' and $hacia="USD"){ //usdt no esta en la lista
        return 1;
    }else{
        return round($out/$in ,4);        
    }
}

//PPRECIO DE UN PAR
function precioPar ($par){
    global $api;
    $price = $api->price($par);
    return $price;
}

//BALANCES
function disponible ($moneda){//en blanco es todo
    global $api;
    try{
        if( $moneda=="" ){
            return $api->btc_value;
        }else{
            $ticker = $api->prices(); // Make sure you have an updated ticker object for this to work, it gets latest price of all symbols
            $balances = $api->balances($ticker);
            return $balances[$moneda]['available'];
        }    
    } catch (Exception $e) {
        return "(por lo general falla cuando la hora esta mal) ".$e->getMessage();
    }
}
function congelado  ($moneda){
    global $api;
    $ticker = $api->prices(); 
    $balances = $api->balances($ticker);
    return $balances[$moneda]['onOrder'];
}
function balance ($moneda){
    global $api;
    $ticker = $api->prices();
    $balances = $api->balances($ticker);
    return $balances[$moneda]['btcTotal'];
}// en BTC siempre***

//LIMITADAS
function ventaLimitada($par,$precio,$cantidad){
    global $api;
    //posición venta (del primero del par)
    try{
        $order = $api->sell($par, $cantidad, $precio);
        return $order;
    } catch (Exception $e) {
        return $par." - No se ejecuto VENTA de ".$cantidad." a ".$precio."<br>Razon del broker:<br />".$e->getMessage();
    }
}
function compraLimitada($par,$precio,$cantidad){
    global $api;
    //posición compra (del primero del par)
    try{
        $order = $api->buy($par, $cantidad, $precio);
        return $order;
    } catch (Exception $e) {
        return $par." - No se ejecuto COMPRA de ".$cantidad." a ".$precio."<br>Razon del broker:<br />".$e->getMessage();
    }    
}
/*
array(14) {
  ["symbol"]=>
  string(7) "BTCUSDT"
  ["orderId"]=>
  int(10909894334)
  ["orderListId"]=>
  int(-1)
  ["clientOrderId"]=>
  string(22) "OsKIBAXHv2sEb0P3cqmE7K"
  ["transactTime"]=>
  int(1654748953012)
  ["price"]=>
  string(14) "28900.00000000"
  ["origQty"]=>
  string(10) "0.00036000"
  ["executedQty"]=>
  string(10) "0.00000000"
  ["cummulativeQuoteQty"]=>
  string(10) "0.00000000"
  ["status"]=>
  string(3) "NEW"
  ["timeInForce"]=>
  string(3) "GTC"
  ["type"]=>
  string(5) "LIMIT"
  ["side"]=>
  string(3) "BUY"
  ["fills"]=>
  array(0) {
  }
}
*/

//MERCADO
function ventaMercado($par,$cantidad){
    global $api;
    //posición venta (del primero del par)
    try{
        $order = $api->sell($par, $cantidad,  0, "MARKET");
        return $order;
    } catch (Exception $e) {
        return $par." - No se ejecuto venta de ".$cantidad." a mercado<br>Razon del broker:<br />".$e->getMessage();
    }
}
function compraMercado($par,$cantidad){
    global $api;
    //posición compra (del primero del par)
    try{
        $order = $api->buy($par, $cantidad,  0, "MARKET");
        return $order;
    } catch (Exception $e) {
        return $par." - No se ejecuto compra de ".$cantidad." a mercado<br>Razon del broker:<br />".$e->getMessage();
    }    
}

//STOP LOSS
function ventaStoploss($par,$precio,$cantidad,$stopPrice){
    global $api;
    //posición venta (del primero del par)
    // When the stop is reached, a stop order becomes a market order
    //$quantity = 0.0004; //primero del par
    //$price = 80000; // Try to sell it for 0.5 btc
    //$stopPrice = 20000; // Sell immediately if price goes below 0.4 btc
    try{
        $order = $api->sell($par, $cantidad, $precio, "STOP_LOSS", ["stopPrice"=>$stopPrice]);
        return $order;
    } catch (Exception $e) {
        return $par." - No se ejecuto StopLoss de ".$cantidad." a ".$precio." con stop loss de ".$stopPrice."<br>Razon del broker:<br />".$e->getMessage();
    }
}

/*
Venta a mercado
array(14) {
  ["symbol"]=>
  string(7) "BTCUSDT"
  ["orderId"]=>
  int(10809963931)
  ["orderListId"]=>
  int(-1)
  ["clientOrderId"]=>
  string(22) "FDjMuJVWoc5TCnVWeCxnqH"
  ["transactTime"]=>
  int(1654107006560)
  ["price"]=>
  string(10) "0.00000000"
  ["origQty"]=>
  string(10) "0.00034000"
  ["executedQty"]=>
  string(10) "0.00034000"
  ["cummulativeQuoteQty"]=>
  string(11) "10.28273900"
  ["status"]=>
  string(6) "FILLED"
  ["timeInForce"]=>
  string(3) "GTC"
  ["type"]=>
  string(6) "MARKET"
  ["side"]=>
  string(4) "SELL"
  ["fills"]=>
  array(1) {
    [0]=>
    array(5) {
      ["price"]=>
      string(14) "30243.35000000"
      ["qty"]=>
      string(10) "0.00034000"
      ["commission"]=>
      string(10) "0.01028274"
      ["commissionAsset"]=>
      string(4) "USDT"
      ["tradeId"]=>
      int(1388830840)
    }
  }
}

Compra Limitada:
array(14) {
  ["symbol"]=>
  string(7) "BTCUSDT"
  ["orderId"]=>
  int(10810067796)
  ["orderListId"]=>
  int(-1)
  ["clientOrderId"]=>
  string(22) "TccNpMje9oxC7VqLS9K8vx"
  ["transactTime"]=>
  int(1654107658128)
  ["price"]=>
  string(14) "28000.00000000"
  ["origQty"]=>
  string(10) "0.00040000"
  ["executedQty"]=>
  string(10) "0.00000000"
  ["cummulativeQuoteQty"]=>
  string(10) "0.00000000"
  ["status"]=>
  string(3) "NEW"
  ["timeInForce"]=>
  string(3) "GTC"
  ["type"]=>
  string(5) "LIMIT"
  ["side"]=>
  string(3) "BUY"
  ["fills"]=>
  array(0) {
  }
}
*/

//ORDENES ABIERTAS
function ordenesAbiertas($par){
    global $api;
    $openorders = $api->openOrders($par);
    $ordenesFiltradas=array();
    $i=0; foreach( $openorders as $key=>$feach){  
        //igual así traes la info de las ordenes que si te es relevante
        $ordenesFiltradas[] = array("pair"=>$par,"orderId"=>$feach["orderId"],"type"=>$feach["type"],"side"=>$feach["side"],"price"=>$feach["price"],"quantity"=>$feach["origQty"],"executed"=>$feach["executedQty"]);
    $i++;}    
    return $ordenesFiltradas;
}
//$openorders = $api->openOrders($par);
//echo "...<pre>";var_dump($openorders);echo "</pre>...";
/*
array(2) {
  [0]=>
  array(18) {
    ["symbol"]=>
    string(7) "BTCUSDT"
    ["orderId"]=>
    int(10810067796)
    ["orderListId"]=>
    int(-1)
    ["clientOrderId"]=>
    string(22) "TccNpMje9oxC7VqLS9K8vx"
    ["price"]=>
    string(14) "28000.00000000"
    ["origQty"]=>
    string(10) "0.00040000"
    ["executedQty"]=>
    string(10) "0.00000000"
    ["cummulativeQuoteQty"]=>
    string(10) "0.00000000"
    ["status"]=>
    string(3) "NEW"
    ["timeInForce"]=>
    string(3) "GTC"
    ["type"]=>
    string(5) "LIMIT"
    ["side"]=>
    string(3) "BUY"
    ["stopPrice"]=>
    string(10) "0.00000000"
    ["icebergQty"]=>
    string(10) "0.00000000"
    ["time"]=>
    int(1654107658128)
    ["updateTime"]=>
    int(1654107658128)
    ["isWorking"]=>
    bool(true)
    ["origQuoteOrderQty"]=>
    string(10) "0.00000000"
  }
  [1]=>
  array(18) {
    ["symbol"]=>
    string(7) "BTCUSDT"
    ["orderId"]=>
    int(10810433470)
    ["orderListId"]=>
    int(-1)
    ["clientOrderId"]=>
    string(36) "web_685f6a2f1be549d29214a501450b276e"
    ["price"]=>
    string(14) "40000.00000000"
    ["origQty"]=>
    string(10) "0.00027000"
    ["executedQty"]=>
    string(10) "0.00000000"
    ["cummulativeQuoteQty"]=>
    string(10) "0.00000000"
    ["status"]=>
    string(3) "NEW"
    ["timeInForce"]=>
    string(3) "GTC"
    ["type"]=>
    string(5) "LIMIT"
    ["side"]=>
    string(4) "SELL"
    ["stopPrice"]=>
    string(10) "0.00000000"
    ["icebergQty"]=>
    string(10) "0.00000000"
    ["time"]=>
    int(1654109206136)
    ["updateTime"]=>
    int(1654109206136)
    ["isWorking"]=>
    bool(true)
    ["origQuoteOrderQty"]=>
    string(10) "0.00000000"
  }
}
*/
//STATUS X ORDEN
function ordenStatus($par,$orden){
    global $api;
    $orderstatus = $api->orderStatus($par, $orden);
    //$orderstatus puede ser NEW, FILLED o CANCELED
    return $orderstatus;
}
/*array(18) {
  ["symbol"]=>
  string(7) "BTCUSDT"
  ["orderId"]=>
  int(11266424782)
  ["orderListId"]=>
  int(-1)
  ["clientOrderId"]=>
  string(22) "mdNoEnvqHC0SRcwMJoe9WI"
  ["price"]=>
  string(14) "30000.00000000"
  ["origQty"]=>
  string(10) "0.00050000"
  ["executedQty"]=>
  string(10) "0.00000000"
  ["cummulativeQuoteQty"]=>
  string(10) "0.00000000"
  ["status"]=>
  string(3) "NEW"
  ["timeInForce"]=>
  string(3) "GTC"
  ["type"]=>
  string(5) "LIMIT"
  ["side"]=>
  string(4) "SELL"
  ["stopPrice"]=>
  string(10) "0.00000000"
  ["icebergQty"]=>
  string(10) "0.00000000"
  ["time"]=>
  int(1656378167977)
  ["updateTime"]=>
  int(1656378167977)
  ["isWorking"]=>
  bool(true)
  ["origQuoteOrderQty"]=>
  string(10) "0.00000000"
}*/
//TRAER TODAS LAS ORDENES DESDE EL INICIO TIEMPOS (NO LO REQUIERES)
function ordenesTodas($par,$cuales){//puede ser TODAS, NEW (abiertas), FILLED o CANCELED
    global $api;
    $orders = $api->orders($par);
    $ord=array();
    $i=0; foreach( $orders as $key=>$feach){ 
        if("TODAS" == $cuales){
            $ord[]=$feach;
        }else{
            if($feach["status"] == $cuales){
                $ord[]=$feach;
            }            
        }
    $i++;}
    return $ord;
}
/*  [4]=>
  array(18) {
    ["symbol"]=>
    string(7) "BTCUSDT"
    ["orderId"]=>
    int(10910923404)
    ["orderListId"]=>
    int(-1)
    ["clientOrderId"]=>
    string(22) "DyHAR7aTB79c9kfHsYTTpz"
    ["price"]=>
    string(14) "32900.00000000"
    ["origQty"]=>
    string(10) "0.00036000"
    ["executedQty"]=>
    string(10) "0.00036000"
    ["cummulativeQuoteQty"]=>
    string(11) "10.93528800"
    ["status"]=>
    string(6) "FILLED"
    ["timeInForce"]=>
    string(3) "GTC"
    ["type"]=>
    string(5) "LIMIT"
    ["side"]=>
    string(3) "BUY"
    ["stopPrice"]=>
    string(10) "0.00000000"
    ["icebergQty"]=>
    string(10) "0.00000000"
    ["time"]=>
    int(1654759365580)
    ["updateTime"]=>
    int(1654759365580)
    ["isWorking"]=>
    bool(true)
    ["origQuoteOrderQty"]=>
    string(10) "0.00000000"
  }*/

//CANCELAR ORDEN
function cancelarOrden($par,$orden){
    global $api;
    try{
        $response = $api->cancel($par, $orden);
        //return ($response);//solo regresa mejor el id del orden
        return "cancelado ".$orden;
    } catch (Exception $e) {
        return $par." - No se Cancelo la  orden ".$orden."<br>Razon del broker:<br />".$e->getMessage();
    }
/*
array(13) {
  ["symbol"]=>
  string(7) "BTCUSDT"
  ["origClientOrderId"]=>
  string(22) "TccNpMje9oxC7VqLS9K8vx"
  ["orderId"]=>
  int(10810067796)
  ["orderListId"]=>
  int(-1)
  ["clientOrderId"]=>
  string(22) "LGwTTiIQqav7B3KB7VjtxD"
  ["price"]=>
  string(14) "28000.00000000"
  ["origQty"]=>
  string(10) "0.00040000"
  ["executedQty"]=>
  string(10) "0.00000000"
  ["cummulativeQuoteQty"]=>
  string(10) "0.00000000"
  ["status"]=>
  string(8) "CANCELED"
  ["timeInForce"]=>
  string(3) "GTC"
  ["type"]=>
  string(5) "LIMIT"
  ["side"]=>
  string(3) "BUY"
}
*/    
}
//CANCELAR TODAS LAS ORDENES
function cancelarTodas ($par){
    global $api;
//    $par="ETHBTC";
    $openorders = ordenesAbiertas($par);
    $res="Error del par ".$par;
    $i=0; foreach( $openorders as $key=>$feach){  
        if($i ==0 ){$res="";}
        if($i >0 ){$res.=";";}
        ///echo $feach["orderId"];echo "<br>";
        $cancelado=cancelarOrden($par,$feach["orderId"]);
        if($cancelado == 'cancelado'){
            $res.=$feach["orderId"];
        }else{
            $res.=str_replace('"', "",str_replace("'", "",str_replace("{", "",str_replace("}", "", $cancelado ))));;            
        }
    $i++;}
    return $res;
}

//HISTORICO TRADES
//$history = $api->history($par);
//echo "...<pre>";var_dump($history);echo "</pre>...";
